package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Axis_FR_door extends FrontDoor
{
	public Axis_FR_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Axis front right door";

		value = 250;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.axis:0x000000D7r, "FR window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D7r, "FR window", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000E2r, "R mirror", actcolor, optical, power );
		} else
		{
			if ( optical-1 >= 0.5 ) addPart( cars.cat_01.axis:0x000000F5r, "R mirror 2", actcolor, optical, power ); else
			addPart( cars.cat_01.axis:0x000000E2r, "R mirror", actcolor, optical, power );
		}
	}
}
